# Location and facility mapping data   --

use bluetowe_fmx;

CREATE TABLE xl_post(
  po_id                smallint unsigned NOT NULL AUTO_INCREMENT,
  po_manager_id        bigint unsigned,
  po_name              varchar(30),
  po_address           varchar(200),
  PRIMARY KEY (po_id)
);


# -List of clients
CREATE TABLE xl_clients(
  cl_id                smallint unsigned NOT NULL AUTO_INCREMENT,
  cl_mnemonic          varchar(40),
  cl_post_id           smallint unsigned,
  cl_staff_manager     bigint unsigned,
  cl_name              varchar(30) DEFAULT NULL,
  cl_address           varchar(30) DEFAULT NULL,
  cl_contact           varchar(30) DEFAULT NULL,
  cl_phones1           varchar(20) DEFAULT NULL,
  cl_phones2             varchar(20) DEFAULT NULL,
  cl_phones3             varchar(20) DEFAULT NULL,
  cl_email               varchar(30),
  cl_rel_status          ENUM('PROSPECT','SIGNED ON','EXISTING JOB','SIGNED OFF'),
  cl_sign_date           datetime,
  cl_month_charge        NUMERIC(10,2),
  cl_annual_charge       NUMERIC(10,2),
  PRIMARY KEY (cl_id)
);



CREATE TABLE xl_location(
  lo_id                smallint unsigned NOT NULL AUTO_INCREMENT,
  lo_client_id         smallint unsigned,
  lo_manager_id        bigint unsigned,
  lo_name              varchar(50),
  lo_contact           varchar(30),
  lo_address           varchar(100),
  lo_phone             varchar(20),
  loc_key_dets         tinytext,
  PRIMARY KEY (lo_id)
);


INSERT INTO xl_post (po_name) VALUES
                        ('HEAD OFFICE'),
                        ('BONNY LNG'),
                        ('ABUJA LINC');

CREATE TABLE xl_property_type(
  type_id                int unsigned NOT NULL AUTO_INCREMENT,
  type_location_id       smallint,
  type_name              varchar(20),
  type_desc              varchar(50),
  deleted                boolean,
  PRIMARY KEY (type_id)
);

/*INSERT INTO xl_property_type (type_location_id,type_name) VALUES
            (1,'AREA'),
            (1,'HOME TYPE 1'),
            (1,'HOME TYPE 2'),
            (1,'HOME TYPE 3'),
            (1,'HOME TYPE 4'),
            (1,'HOME TYPE A'),
            (1,'HOME TYPE B'),
            (1,'HOME TYPE C'),
            (1,'238 APARTMENTS'),
            (1,'SCHOOL'),
            (1,'CLUB HOUSE'),
            (1,'KITCHEN'),
            (1,'GUEST HOUSE'),
            (1,'WORK SHOP'),
            (1,'SHOPPING MALL'),
            (1,'WAREHOUSE'),
            (1,'STATION');
*/

CREATE TABLE property(
  prop_id                bigint unsigned NOT NULL AUTO_INCREMENT,
  prop_location_id       smallint unsigned,
  prop_type_id           smallint unsigned,
  prop_container_id      bigint unsigned,
  prop_name              varchar(30),
  prop_occu_name         varchar(30),
  prop_occu_tel_no       varchar(20),
  prop_address           varchar(20),
  prop_street_name       varchar(50),
  prop_con_type          ENUM('LOC','INFRA','AREA'),
  prop_type              ENUM('AREA','PROP'),
  deleted                boolean,
  PRIMARY KEY (prop_id)
);
# INSERT INTO property (prop_id,prop_location_id,prop_container_id) VALUES
#  RESIDENTIAL AREA,


CREATE TABLE infra_type(
  infra_type_id                smallint unsigned NOT NULL AUTO_INCREMENT,
  infra_type_loc_id            smallint unsigned, 
  infra_type_name              varchar(30),
  infra_type_desc              varchar(50),
  deleted                      boolean,
  PRIMARY KEY (infra_type_id)
);

INSERT INTO infra_type (infra_type_name) VALUES
                       ('ROAD'),
                       ('SEWAGE');

CREATE TABLE infrastructure(
  inf_id                bigint unsigned NOT NULL AUTO_INCREMENT,
  inf_type_id           smallint unsigned,
  infra_location_id     smallint unsigned,
  infra_con_type        ENUM('INFRA','PROP','LOC','AREA'),
  inf_container_id      bigint unsigned,
  inf_desc              tinytext,
  inf_address           varchar(50),
  deleted               boolean,
  PRIMARY KEY (inf_id)
);


CREATE TABLE property_item(
  item_id                bigint unsigned NOT NULL AUTO_INCREMENT,
  item_prop_id          bigint unsigned,
  item_con_type          ENUM('INFRA','PROP','LOC'),
  item_grp_id            smallint unsigned,
  item_store_id          bigint unsigned,       #--materrial xl_store table in DB
  item_label             varchar(20),
  item_make              varchar(30),
  #item_manu_year         datetime,
  item_model             varchar(30),
  item_power_rating      varchar(10),
  item_installation_date datetime,
  item_next_ppm_date     datetime,
  item_las_service_id    bigint unsigned,
  item_last_fault_id     bigint unsigned,
  deleted               boolean,
   PRIMARY KEY (item_id)
);

#-- END OF MAPPING


#--Facility management data

# verify usage of ppm
CREATE TABLE ppm(
  ppm_id                 bigint unsigned NOT NULL AUTO_INCREMENT,
  ppm_type               ENUM('SERVICING','FAULTS','MAINTENANCE'),
  ppm_reporter_type      ENUM('CLIENT','STAFF','AUTO'),  #AUTO when it origonated direct from down
  ppm_reporter_id        bigint unsigned,
  ppm_prop_id            bigint unsigned,
  ppm_prop_type          ENUM('LOC','AREA','PROP','INFRA','ITEM'),
  ppm_date               datetime,
  ppm_request_desc       tinytext,
  ppm_assign_desc        tinytext,
  ppm_assign_date        datetime,
  ppm_assign_type        ENUM('NEGLECT','SERVICING','FAULTS','MAINTENANCE'),
  ppm_assign_id          bigint unsigned,
  PRIMARY KEY (ppm_id)
);


CREATE TABLE maintenance_types(
  mn_type_id            smallint unsigned NOT NULL AUTO_INCREMENT,
  mn_type_name          varchar(30),
  mn_type_code          varchar(20),
  mn_type_desc         tinytext,
  PRIMARY KEY (mn_type_id)
);


CREATE TABLE maintenance(
  mn_id                 bigint unsigned NOT NULL AUTO_INCREMENT,
  mn_ppm_id             bigint unsigned,    #ppm_id
  #mn_type              ENUM('PROPERTY','INFRA','AREA','PAID'),
  #mn_prop_id           bigint unsigned,
  #mn_demand_date       datetime,
  mn_done_date          datetime,
  mn_confirm_date       datetime,
  mn_stf_id             bigint unsigned,
  mn_stf_inputer        bigint unsigned,
  mn_desc               tinytext,
  mn_preceed            bigint unsigned,
  mn_other_cost         NUMERIC(10,2),
  mn_material_cost      NUMERIC(10,2),
  mn_stf_count          smallint unsigned,
  mn_hours              smallint unsigned,
  mn_invoiced           boolean,
  mn_inv_date            datetime,
  PRIMARY KEY (mn_id)
);

CREATE TABLE item_service(
  ser_id                 bigint unsigned NOT NULL AUTO_INCREMENT,
  #ser_item_id            bigint unsigned NOT NULL,
  ser_ppm_id             bigint unsigned,     #ppm_id
  #ser_req_date           datetime,
  ser_done_date          datetime,
  ser_confirm_date        datetime,
  ser_stf_id             bigint unsigned,
  ser_stf_inputer        bigint unsigned,
  ser_desc               bigint unsigned,
  ser_preceed            bigint unsigned,
  ser_fault_rep          boolean,
  ser_payment_type       ENUM('INVOICE','CONTRACT'),   
  ser_material_cost      NUMERIC(10,2),
  ser_stf_count          smallint unsigned,
  ser_hours              smallint unsigned,
  ser_invoiced           boolean,
  ser_inv_date            datetime,
  PRIMARY KEY (ser_id)
);


CREATE TABLE item_fault(
  flt_id                 bigint unsigned NOT NULL AUTO_INCREMENT,
  #flt_item_id            bigint unsigned,
  flt_type_id            smallint unsigned,
  flt_ppm_id             bigint unsigned,  #ppm_id   
  flt_report_type        ENUM('OCCUPANT','SERVICING','CLIENT REPORT','PPM ISP'),
  #flt_reported_date      datetime,
  flt_repair_date        datetime,
  flt_confirm_date        datetime,
  #flt_desc               tinytext,
  flt_repair_desc        tinytext,
  flt_repair_stf_id      bigint unsigned,
  flt_stf_inputer        bigint unsigned,
  #flt_preceed            bigint unsigned,
  flt_payment_type       ENUM('INVOICE','CONTRACT'),
  flt_other_cost         NUMERIC(10,2),
  flt_material_cost      NUMERIC(10,2),
  flt_stf_count          smallint unsigned,
  flt_hours              smallint unsigned,
  tlt_invoiced           boolean,
  flt_inv_date            datetime,
  PRIMARY KEY (flt_id)
);

CREATE TABLE item_fault_type(
  flt_type_id            smallint unsigned NOT NULL AUTO_INCREMENT,
  #flt_item_id           bigint unsigned,
  flt_type_name          varchar(20),
  flt_type_code          varchar(30),
  flt_type_desc         tinytext,
  PRIMARY KEY (flt_type_id)
);

CREATE TABLE installations(
  ins_id                 bigint unsigned NOT NULL AUTO_INCREMENT,
  ins_item_id            bigint unsigned,
 # ins_prop_id            bigint unsigned,
 # ins_prop_type          ENUM('PROP','INFRA'),
  ins_type               ENUM('REPLACEMENT','NEW'),
  ins_date               datetime,
  ins_confirm_date       datetime,
  ins_staff              bigint unsigned,
  ins_stf_inputer        bigint unsigned,
  ins_desc               tinytext,
  ins_material_cost      NUMERIC(10,2),
  ins_other_cost         NUMERIC(10,2),
  ins_stf_count          smallint unsigned,
  ins_hours              smallint unsigned,
  ins_payment_type       ENUM('INVOICE','CONTRACT'),
  ins_invoiced           boolean,
  ins_inv_date            datetime,
  PRIMARY KEY (ins_id)
);

CREATE TABLE inst_temp(
  tm_id     smallint unsigned NOT NULL AUTO_INCREMENT,
  tm_date   datetime,
  PRIMARY KEY (tm_id)
);

#--End of facility Management data

#--Procurement
#/*CREATE TABLE procurement_limits(
 # limit_id              smallint unsigned NOT NULL AUTO_INCREMENT,
  #limit_position        smallint,
#  Limit_amount          NUMERIC(10,2),
 # PRIMARY KEY (limit_id)
#);
#   moved */

CREATE TABLE item_requisition(
  re_id                 bigint unsigned NOT NULL AUTO_INCREMENT,
 # re_item_id            bigint unsigned,
  re_type               ENUM('STORE','SERVICING','FAULTS','INSTALLATION','MAINTENANCE','PAID','JOB','TEMP'),
  re_use_id             bigint unsigned,
  re_com_1              bigint unsigned,
  re_com_2              bigint unsigned,
  re_com_3              bigint unsigned,
  re_com_amt_1          NUMERIC(10,2),
  re_com_amt_2          NUMERIC(10,2),
  re_com_amt_3          NUMERIC(10,2),
  re_com_just           tinytext,
  re_com                bigint unsigned,
  re_amount             NUMERIC(10,2),
  re_date               datetime,
  re_approve_date       datetime,
  re_staff_id           bigint unsigned,
  re_approve_id         bigint unsigned,
  re_lpo_raised         boolean,
  PRIMARY KEY (re_id)
);

CREATE TABLE requisition_mat(
    rm_re_id            bigint unsigned,
    rm_mat_id           bigint unsigned,
    rm_quantity         smallint unsigned,
    rm_unit_amt         NUMERIC(10,2),
    rm_total_amt        NUMERIC(10,2),
    rm_status           ENUM('STORE','EXPSTORE','SERVICING','FAULTS','INSTALLATION','MAINTENANCE','PAID','JOB','TEMP','EXPENSE','EXTEMP'),
    PRIMARY KEY (rm_re_id,rm_mat_id,rm_status)
);

CREATE TABLE lpo(
  lpo_id                 bigint unsigned NOT NULL AUTO_INCREMENT,
  lpo_item_req_id        bigint unsigned,
  re_invioce_ref       varchar(20),
  re_lpo_ref           varchar(20),
  re_lpo_date          datetime,
  re_desc               tinytext,
  re_receipt_date     datetime,
  re_bank_detail       varchar(30),
  re_cheque_detail    varchar(20),
  re_pyt_date           datetime,
  PRIMARY KEY (lpo_id)
);

CREATE TABLE cash_purchases(
  py_id                 bigint unsigned NOT NULL AUTO_INCREMENT,
  py_approval_id        bigint unsigned,
  py_staff_id           bigint unsigned,
  py_expense_form_ref   varchar(20),
  py_amount            NUMERIC(10,2),
  py_refund             bigint,
  py_date              datetime,
  py_bank_detail       varchar(30),
  py_cheque_detail     varchar(20),
  PRIMARY KEY (py_id)
);


CREATE TABLE xl_express_approvals(
  ex_id                      bigint unsigned NOT NULL AUTO_INCREMENT,
  ex_use_type                ENUM('EXPSTORE','SERVICING','FAULTS','INSTALLATION','MAINTENANCE','PAID','JOB','TEMP'),
  ex_use_id                  bigint unsigned,
  ex_stage                   ENUM('PENDING','PROCESSING','APPROVED','DISBURSED','RETIRED'),
  ex_initiator               bigint unsigned,
  ex_authoriser              bigint unsigned,
  ex_description             tinytext,
  ex_approver                bigint unsigned,
  ex_amount                  NUMERIC(10,2),
  ex_init_date              datetime,
  ex_approve_date           datetime,
  ex_disbure_date           datetime,
  ex_spent                  NUMERIC(10,2),
  PRIMARY KEY (ex_id)
);

#--End of Procurement

#--Job/Project data

CREATE TABLE xl_history (
  his_id                bigint unsigned NOT NULL AUTO_INCREMENT,
  his_job_id            bigint unsigned DEFAULT NULL,
  his_detail            MEDIUMTEXT DEFAULT NULL,
  PRIMARY KEY (his_id)
);

#-- A table of accepted stages from Job reception to Completion.
#-- A job entry must have a matching column entry from this table
CREATE TABLE xl_job_stages (
  st_id                tinyint(5) unsigned NOT NULL,
  st_detail            varchar(20) DEFAULT NULL,
  PRIMARY KEY (st_id)
);

INSERT INTO xl_job_stages (st_id, st_detail) VALUES
                      (0, 'Posted'),
                      (1, 'Detailing'),
                      (2, 'Scoping'),
                      (3, 'Quotation'),
                      (4, 'Job Order'),  
                      (5, 'Health'),
                      (6, 'Contracting'),
                      (7, 'Requisition'),
                      (8, 'Execution'),
                      (9, 'Confirmed'),
                      (10, 'Invoicing'),
                      (11, 'Payment'),
                      (12, 'Express'),
                      (13, 'Stopped');

CREATE TABLE xl_temp_jobs(
    job_temp_id         smallint unsigned NOT NULL AUTO_INCREMENT,
    job_cl_id           bigint unsigned,
    job_classification  ENUM('MAINTENANCE','PAID','JOB'),
    job_narration       tinytext,
    job_poster_id       bigint unsigned,
    job_poster_type     ENUM('CLIENT', 'STAFF'),
    job_order_date      datetime,
    job_moved           boolean,              
    PRIMARY KEY (job_temp_id)
);

#--Jobs table
CREATE TABLE xl_jobs(
  job_id                bigint unsigned NOT NULL AUTO_INCREMENT,
  job_cl_id             bigint unsigned,
  #job_location_id       bigint unsigned,
  job_item_id           bigint unsigned,
  job_item_type         ENUM('PROP','INFRA','ITEM','NONE'),
  job_order_ref         varchar(20),
  job_order_date        datetime,
  job_invioce_ref       varchar(20),
  job_invoice_date      datetime,
  job_poster_id         bigint unsigned,
  job_poster_type       ENUM('CLIENT','STAFF'),
  job_supervisor        bigint unsigned,
  job_classification    ENUM('MAINTENANCE','PAID','JOB'),
  job_scoper_id         bigint unsigned,
  job_tenor             ENUM('FIXED', 'REPEATING'),
  job_tenor_cycle       ENUM('ONE OFF','DAILY','WEEKLY','FORTNIGHTLY','MONTHLY','BIMONTHLY','QUATERLY','BIANNUALLY','ANNUALLY','BIENNIAL') ,
  job_type              ENUM('INHOUSE','CONTRACTING','BOTH'),
  job_status_id         smallint(4),
  job_reciept_date      datetime,
  job_start_date        datetime,
  job_end_projection    datetime,
  job_end_date          datetime,
  job_confirmer_id      bigint unsigned,
  job_quotation_id      bigint unsigned,
  job_invoicing_id      bigint unsigned,
  job_payment_id        bigint unsigned, 
  job_rating            ENUM('FAILED','POOR','FAIR','GOOD','EXCELLENT'),
  job_stopped_reason    ENUM('CLIENT ORDER','CLIENT APPROVAL','MATERIAL','FAULT','INTERNAL APPROVAL'),
  job_cost_estimate     NUMERIC(10,2),
  job_quoted_amt        NUMERIC(10,2),
  job_accrual           NUMERIC(10,2),
  job_paydet            varchar(100),
  job_narration          tinytext,
  job_scoping_det        tinytext,
  job_health_and_safety  ENUM('NONE','TASK','CONTRACT'),
  job_h_and_s_id         bigint unsigned,
  PRIMARY KEY (job_id)
);

CREATE TABLE xl_task_class(
  ts_cl_id               smallint unsigned NOT NULL AUTO_INCREMENT,
  ts_cl_name            varchar(50),
  ts_cl_description     varchar(100) DEFAULT NULL,
  ts_cl_creator_id       bigint unsigned,
  PRIMARY KEY (ts_cl_id)
);

CREATE TABLE xl_con_class(
  con_cl_id               smallint unsigned NOT NULL AUTO_INCREMENT,
  con_cl_name            varchar(50),
  con_cl_description     varchar(100) DEFAULT NULL,
  con_cl_creator_id       bigint unsigned,
  PRIMARY KEY (con_cl_id)
);

# -- Inhouse tasks

CREATE TABLE xl_job_tasks(
  task_id                bigint unsigned NOT NULL AUTO_INCREMENT,
  task_job_id            bigint unsigned,
  task_supervisor        bigint unsigned,
  #task_staff_ids        bigint unsigned,
  task_cycle             ENUM('ONE OFF','DAILY','WEEKLY','FORTNIGHTLY','MONTHLY','BIMONTHLY','QUATERLY','BIANNUALLY','ANNUALLY','BIENNIAL'),
  task_prec              bigint unsigned,
  task_rollover          boolean,
  task_express           boolean,
  task_start_date        datetime,
  task_no_days           smallint unsigned,
  task_end_date          datetime,
  task_summary           varchar(50),
  task_description       tinytext,
  tast_material_status   ENUM('NONE REQUIRED','PENDING','PROCURED'),
  task_status            ENUM('NOT ASSIGNED','ASSIGNED','COMPLETED','VERIFIED'),
  task_rating            ENUM('FAILED','POOR','FAIR','GOOD','EXCELLENT'),
  task_material_cost     NUMERIC(10,2),
  task_other_cost        NUMERIC(10,2),
  task_no_staff          tinyint(5) unsigned,
  PRIMARY KEY (task_id)
);

CREATE TABLE xl_tasks_material(
  mat_id                bigint unsigned NOT NULL AUTO_INCREMENT,
  mat_task_id           bigint unsigned,
  mat_task_type         ENUM('JOB','FAULTS','SERVICING','MAINTENANCE','INSTALLATION','TEMP'),
  mat_mat_id            bigint unsigned,
  mat_request_date      datetime,
  mat_provision_date    datetime,
  mat_requisition       ENUM('PENDING','STORE','DIRECT PURCHASE','CLIENT PROVISION'),
  mat_status            ENUM('PENDING','ON ORDER','AWAIT APPROVAL','READY','PROVIDED'),
  mat_staff_req_id      bigint unsigned,
  mat_receiver_id       bigint unsigned,
  mat_quantity          smallint unsigned,
  mat_store             smallint unsigned,
  mat_ref_type          ENUM('RELEASE ORDER','INVOICE','CLIENT','OTHERS'),
  mat_ref               varchar(20),
  mat_cost              NUMERIC(10,2),
  mat_unit_cost         NUMERIC(10,2),
 # mat_cost_desc         tinytext,
  PRIMARY KEY (mat_id,mat_task_id)
);


#-- List of contracts given to contractors
CREATE TABLE xl_contracts(
  cont_id                bigint unsigned NOT NULL AUTO_INCREMENT,
  cont_lpo_no            varchar(20),
  cont_job_id            bigint unsigned DEFAULT NULL,
  cont_con_id            bigint unsigned DEFAULT NULL,
  cont_officer           bigint unsigned,  
  cont_giver_id          bigint unsigned,
  cont_cycle             ENUM('ONE OFF','DAILY','WEEKLY','FORTNIGHTLY','MONTHLY','BIMONTHLY','QUATERLY','BIANNUALLY','ANNUALLY','BIENNIAL') ,
  cont_prec              bigint unsigned,
  cont_rollover          boolean,
  cont_start_date        datetime DEFAULT NULL,
  cont_no_days           smallint unsigned,
  cont_end_date          datetime DEFAULT NULL,
  cont_amount            NUMERIC(10,2),
  cont_mob_amt           NUMERIC(10,2),
  cont_paid              boolean,
  cont_approved          boolean,
  cont_status            ENUM('NOT ASSIGNED','AWARDED','NOTIFIED','MOBILISED','COMPLETED','VERIFIED'),
  cont_rating            ENUM('FAILED','POOR','FAIR','GOOD','EXCELLENT'),
  cont_approver          bigint unsigned,
  cont_details           tinytext,
  con_summary            varchar(50),
  cont_remark            tinytext,
  deleted                boolean,
  vendor1                bigint unsigned,
  vendor2                bigint unsigned,
  vendor3                bigint unsigned,
  amount1                NUMERIC(10,2),
  amount2                NUMERIC(10,2),
  amount3                NUMERIC(10,2),
  PRIMARY KEY (cont_id)
);

#-- END OF JOB DATA


#-- CONTRACTOR & VENDORS

#-- A list of contractors for Xl
CREATE TABLE xl_contractors(
  con_id                bigint unsigned NOT NULL AUTO_INCREMENT,
  con_mnemonic          varchar(40),
  con_name              varchar(30) DEFAULT NULL,
  con_address           varchar(100) DEFAULT NULL,
  con_contact           varchar(30) DEFAULT NULL,
  con_phone1             varchar(20) DEFAULT NULL,
  con_phone2             varchar(20) DEFAULT NULL,
  con_phone3             varchar(20) DEFAULT NULL,
  con_email              varchar(30),
  con_rel_status         ENUM('PROSPECT','REGISTERED','EXISTING JOB', 'DEFAULTED','DELISTED'),
  con_speciality         varchar(50),
  deleted                boolean,
  con_sign_date          datetime,
  PRIMARY KEY (con_id)
);

CREATE TABLE xl_vendors(
  ven_id              bigint unsigned NOT NULL AUTO_INCREMENT,
  ven_short           varchar(20),
  ven_name            varchar(100),
  ven_contact         varchar(30),
  ven_address         varchar(100),
  ven_st_manager_id   bigint unsigned,
  ven_item_grp_id     smallint unsigned,
  ven_st_grp_id       bigint unsigned,
  ven_phones1         varchar(20) DEFAULT NULL,
  ven_phones2         varchar(20) DEFAULT NULL,
  ven_phones3         varchar(20) DEFAULT NULL,
  ven_email           varchar(30),
  ven_rel_status      ENUM('PROSPECT','EXISTING','DEFAULTED','DELISTED'),
  ven_sign_date       datetime,
  PRIMARY KEY (ven_id)
);


#-- END


#-- STAFF DATA

#-- Staff Right Status to control data input and information Access

CREATE TABLE xl_staff_status (
  stu_id              smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  stu_desc            varchar(30) DEFAULT NULL,
  stu_power           smallint(4) unsigned NOT NULL,
  stu_limit_amount     NUMERIC(10,2),
  PRIMARY KEY (stu_id)
);

INSERT INTO xl_staff_status (stu_desc,stu_power) VALUES
       ('MASTER',15),
       ('MD CEO',0),
       ('MD FMX',0),
       ('HOP',0),
       ('MANAGER',1),
       ('SURVEYOR',2),
       ('SUPERVISOR',3),
       ('TECHNICIAN',4),
       ('ACCOUNTANT',5),
       ('ADMIN',6),
       ('CONTROL',7),
       ('STORE',8),
       ('CONTRACTOR',9),
       ('CLIENT',10);


#-- Staff User Record with system access details.
CREATE TABLE xl_staff (
  stf_id              int unsigned NOT NULL AUTO_INCREMENT,
  stf_id_no           varchar(15),
  stf_name            varchar(30) DEFAULT NULL,
  stf_address           varchar(30) DEFAULT NULL,
  stf_phone1             varchar(30) DEFAULT NULL,
  stf_phone2             varchar(30) DEFAULT NULL,
  stf_email              varchar(50),
  stf_post_id            smallint unsigned,
  stf_date_employed      datetime,
  PRIMARY KEY (stf_id)
);

INSERT INTO xl_staff (stf_id_no, stf_name,stf_email,stf_post_id) VALUES
       ('334','SYSTEM','godwin.aleke@gmail.com',1);

CREATE TABLE xl_users(
  user_id               bigint unsigned NOT NULL AUTO_INCREMENT,
  user_type             ENUM('STAFF','CLIENT','CONTRACTOR','VENDOR'),
  user_tb_id             bigint unsigned,
  user_name              varchar(30) DEFAULT NULL,
  user_password          tinytext DEFAULT NULL,
  user_status_id         smallint(4) unsigned,
  user_logged            boolean,
  user_log_on_det        tinytext,
  user_specialty         varchar(20),
  deleted           boolean,
  PRIMARY KEY (user_id)
);

INSERT INTO xl_users (user_type,user_tb_id,user_name,user_password,user_status_id) VALUES
       ('STAFF',1,'godman',MD5('xl&godman=2'),1);

#--END OF STAFF USER

#--STORE MANAGEMENT
CREATE TABLE xl_unit_measure(
  ms_id              smallint unsigned NOT NULL AUTO_INCREMENT,
  ms_name            varchar(20),
  ms_creator         bigint unsigned,
  PRIMARY KEY (ms_id)
);


CREATE TABLE xl_item_grp(
  item_grp_id                smallint unsigned NOT NULL AUTO_INCREMENT,
  item_grp_name              varchar(30),
  item_grp_desc              tinytext,
  PRIMARY KEY(item_grp_id)   
);

CREATE TABLE xl_store_grp(
  stgrp_id           smallint unsigned NOT NULL AUTO_INCREMENT,
  stgrp_name         varchar(50),
  stgrp_item_grp_id  smallint unsigned,
  stgrp_description  varchar(100),
  PRIMARY KEY (stgrp_id)
);



CREATE TABLE xl_materials(
  mat_id              bigint unsigned NOT NULL AUTO_INCREMENT,
  mat_grp_id          smallint unsigned,
  mat_item_name       varchar(50),
  mat_item_desc       tinytext,
  mat_measure_id      smallint unsigned,
  mat_creator         bigint unsigned,
  PRIMARY KEY (mat_id)
);

CREATE TABLE xl_store(
  st_id              smallint unsigned NOT NULL AUTO_INCREMENT,
  st_type            ENUM('LOCATION','CLIENT','POST'),
  st_base_id         smallint unsigned,   #rep, loc,client,post,
  st_post            bigint unsigned,  
  st_staff           bigint unsigned,
  st_creator         bigint unsigned,
  PRIMARY KEY (st_id)
);

CREATE TABLE xl_store_stock(
  #ss_id              bigint unsigned NOT NULL AUTO_INCREMENT,
  ss_store_id        smallint unsigned,
  ss_mat_id          bigint unsigned,
  ss_stock_min       smallint unsigned,
  ss_quantity        smallint unsigned,
  ss_demand_float    smallint unsigned,
  ss_contract_cost   NUMERIC(10,2) unsigned,
  ss_cur_cost        NUMERIC(10,2) unsigned,
  PRIMARY KEY (ss_store_id,ss_mat_id)
);

CREATE TABLE xl_stock_in(
  stkin_invoice       varchar(20),
  stkin_mat_id          bigint unsigned,
  stkin_store_id        smallint unsigned,
  stkin_date            datetime,
  stkin_quantity        smallint unsigned,
  stkin_vendor          bigint unsigned,
  stkin_goods_receiver_id bigint unsigned,
  PRIMARY KEY (stkin_invoice,stkin_mat_id,stkin_store_id)
);

CREATE TABLE xl_stock_out(
  stkout_rel_order       varchar(20),
  stkout_date            datetime,
  stkout_store_id        smallint unsigned,
  stkout_mat_id          bigint unsigned,
  stkout_quantity        smallint unsigned,
  stkout_job_id          bigint unsigned,
  stkout_job_type        ENUM('STORE','SERVICING','FAULTS','INSTALLATION','MAINTENANCE','PAID','JOB','OTHER'),
  stkout_reciver_id      bigint unsigned,
  PRIMARY KEY (stkout_rel_order,stkout_mat_id,stkout_store_id)
);


CREATE TABLE xl_direct_order(
  do_id              bigint unsigned NOT NULL AUTO_INCREMENT,
  # POST id
  do_invoice_no      varchar(20),
  do_lpo_no          varchar(20),
  do_date            datetime,
  #do_store_id        smallint,
  do_unit_cost       NUMERIC(10,2) zerofill,
  do_quantity        smallint zerofill,
  do_other_cost      NUMERIC(10,2) zerofill,
  do_total           NUMERIC(10,2) zerofill,
  do_desc            tinytext,
  do_user_type       ENUM('JOB','SERVICING','FAULTS','PAID','INSTALLATION','MAINTENANCE'),
  do_user_id          varchar(20),
  do_reciver_id      varchar(20),
  PRIMARY KEY (do_id)
);

CREATE TABLE xl_constant(
    co_id             smallint unsigned NOT NULL AUTO_INCREMENT,
    co_name           varchar(20),
    co_value          smallint unsigned,
    PRIMARY KEY (co_id)
);


